<?php
/* Version 2.1.0 */
$t4_config = array();
$t4_config['config']    = '/cas-access-control/frontend-files/media-library/config.json';
$t4_config['phar']      = '/cas-access-control/vendor/autoload.php';
$t4_config['groups']    = '<t4 type="accesscontrol" output="groupnames" />';
$t4_config['restrict']  = true;
$t4_config['logic']  	= 'or';

try {
    include_once(((strpos($t4_config['phar'], '.phar') !== false) ? 'phar://' : '').$_SERVER['DOCUMENT_ROOT'].$t4_config['phar'].'/vendor/autoload.php');

    if (!class_exists('\AccessControl\Core\Config')) {
        throw new \Exception('AccessControl Library is not loaded correctly');
    }

    if (!empty($t4_config['config'])) {
        AccessControl\Core\Config::setJSON($_SERVER['DOCUMENT_ROOT'].$t4_config['config']);
    }

    $accessControl = \AccessControl\Core\TypeFactory::getInstance();
    $accessControl->isRestrictedMedia($t4_config['restrict'], $t4_config['logic']);
} catch (Exception $e) {
    if ($e->getCode() === 1001) {
        http_response_code(404);
        header('Location: '.AccessControl\Core\Config::get('redirectNotFound'));
        exit;
    }
    if ($e->getCode() === 1000) {
        http_response_code(403);
        header('Location: '.AccessControl\Core\Config::get('redirectNoAccess'));
        exit;
    }
    echo $e->getMessage();
}
