<?php
/* Version 2.1.0 */
$t4_config = array();
$t4_config['config']    = '<t4 type="media" formatter="path/*" id="<!-- INSERT ID -->" />';
$t4_config['phar']      = '<t4 type="media" formatter="path/*" id="<!-- INSERT ID -->" />';
$t4_config['groups']    = '<t4 type="accesscontrol" output="groupnames" />';
$t4_config['restrict']  = true;
$t4_config['logic']     = 'or';


try {
    include_once(((strpos($t4_config['phar'], '.phar') !== false) ? 'phar://' : '').$_SERVER['DOCUMENT_ROOT'].$t4_config['phar'].'/vendor/autoload.php');


    if (!class_exists('\AccessControl\Core\Config')) {
        throw new \Exception('AccessControl Library is not loaded correctly');
    }
    if (!empty($t4_config['config'])) {
        AccessControl\Core\Config::setJSON($_SERVER['DOCUMENT_ROOT'].$t4_config['config']);
    }

    $accessControl = \AccessControl\Core\TypeFactory::getInstance();

    if (!$accessControl->isInGroup($t4_config['groups'], $t4_config['restrict'], true, null, $t4_config['logic'], false)) {
        error_log("group not found");
        throw new \Exception("Group not found", 403);
    }

    if (AccessControl\Core\Config::get('type') === 'Variables' && !$accessControl->isLoggedIn()) {
        if (!$accessControl->isLoginPage()) {
            $accessControl->redirectToLogin();
        } elseif ($accessControl->isLoginPage(true) && isset($_GET['r']) && filter_var((isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://". $_SERVER['HTTP_HOST'] . urldecode($_GET['r']), FILTER_VALIDATE_URL, FILTER_FLAG_PATH_REQUIRED) !== false) {
            $accessControl->redirectToURL(urldecode($_GET['r']));
        }
    }    

    if (AccessControl\Core\Config::get('type') !== 'Variables') {
        if (isset($_GET['r']) && $accessControl->isLoginPage(true) && !$accessControl->isLoggedIn()) {
            //stay on login page
        } else if (isset($_GET['r']) && $accessControl->isLoginPage(true)) {
            $pathToRedirectTo = filter_var(urldecode($_GET['r']));
            if (preg_match('/^\/[A-Za-z0-9_\-\.\/]*$/ui', $pathToRedirectTo)) {
                $accessControl->redirectToURL($pathToRedirectTo, 200);
            }
        } else {
            $pathToRedirectTo = $accessControl->getDestinationBasedOnGroup();
            if (!is_null($pathToRedirectTo)) {
                $accessControl->redirectToURL($pathToRedirectTo, 200);
            }
        }
    }
?>
